/**
 * 
 */
package gov.va.med.mhv.usermgmt.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.VoidServiceResponse;

import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;

/**
 * @author Rob Proper
 *
 */
public class TestPatientService extends UserProfileTestCase {
	
	static final Log LOG = LogFactory.getLog(TestPatientService.class);
	
    public static final String PROPERTY = 
        "testPatientService.userName";
    
	/**
	 * Constructor for UserServiceAuthenticateTest.
	 * @param arg0
	 */
	public TestPatientService(String arg0) {
		super(arg0);
	}

    public void testCorrelateWithoutPatient() throws Exception {
        VoidServiceResponse response = getPatientService().correlate(null);
        assertUnrecoverableExceptionOccurred(response);
    }

	public void testCorrelateForNonExistantPatient() throws Exception {
        VoidServiceResponse response = getPatientService().correlate(
            TransferObjectFactory.createPatient());
        assertUnrecoverableExceptionOccurred(response);
    }

    public void testCorrelateForPatient() throws Exception {
        if (!hasStagedPatientName("testCorrelateForPatient")) {
            return;
        }
        UserProfile userProfile = getUserProfile(getStagedPatientName());
        assertNotNull("User '" + getStagedPatientName() + "' not found", 
            userProfile);
        Patient originalPatient = getPatientForUser(userProfile);
        try {
            VoidServiceResponse response = getPatientService().correlate(
                originalPatient);
            assertNoErrors(response);
            Thread.sleep(3000);
        } finally { 
            // Reset the patient
            savePatient(originalPatient, "Failed to restore patient");
        }
    }

    protected String getStagedPatientNameProperty() {
        return PROPERTY;
    }


}
